' Started....24/09/17
' Microcontroller used:  Microchip Technology PIC16F88
'                        microchip.com
' PicBasic Pro Code: micro-Engineering Labs, Inc.
'                    melabs.com 

'--------Program Desciption--------

'To display the temperature and humidity on an LCD display Using DHT22 module
  #CONFIG
 __CONFIG    _CONFIG1, _CP_OFF & _CCP1_RB0 & _DEBUG_OFF & _WRT_PROTECT_OFF & _CPD_OFF & _LVP_OFF & _BODEN_OFF & _MCLR_ON & _PWRTE_ON & _WDT_OFF & _HS_OSC
 #ENDCONFIG    
'
' 
                                                                                                                                    
 
 
    define LCD_DREG PORTA'PORTA is LCD data PORT
    define LCD_DBIT 0 'PORTA.0 is the data lowest significanr bit  
    define LCD_RSREG PORTA   ' PORTA - RS port   
    define LCD_RSBIT 4       ' RS bit connects to PORTA.4
    define LCD_EREG PORTB ' PORTB E PORT
    define LCD_EBIT 3    ' E to RB3
    Define LCD_BITS 4 '4 data lines used
    define LCD_LINES 2  'The LCD display that is used is 1 line 16 character
    'To make it work you have to treat it as a 2 line display. The first 8
    ' characters are written on the 1st line and the 2nd 8 on the 2nd line.
    Define LCD_COMMANDUS 3000 'Set command delay time to 3ms
    define LCD_DATAUS 150 'Set data delay to 150 micro second
    
     
       
'------------Variables-------------
humread     var word             '16-bit var to store humidity
tmpread     var word             '16-bit var to store temperature
checksum    var BYTE             '8-bit var to store checksum
x           var byte             'general var
pulse       var byte [81]        'store pulse var
p           var bit [81]         'store pulse var
check var byte
y var byte
a var byte
b var byte
c var byte
d var byte
'----------Initialization----------
    Define OSC 20 	'  20Mhz osc 
    ANSEL = %00000000  ' All portA digital           
                       
    TRISB = %00000000 ' all RB Output                   
    TRISA = %00100000 ' RA5 inputs rest outputs                  
  
    
   CMCON = 7 'comparitors off
   INTCON = %00000000 'interrupts off   
    
  
 
  PAUSE 500 ' Wait 0.5 sec for LCD to initialize
   humread =0
   tmpread =0
   checksum = 0
   Y = 0
'-------------Main Code------------
   Start: 
   checksum = 0
   Y = 0  
   
   	TRISB.0 = 0                   'Data port is output
	PORTB.0 = 1                   'high on data port
	pauseus 10                    'send 10uS high pulse to temp/humidity module
	PORTB.0 = 0                     
	pause 1                       'send 1mS high pulse to temp/humidity module
	PORTB.0 = 1                   'High on data port

	'wait response from temp/humidity module
	TRISB.0 = 1    'Data port is input
	pulsin PORTB.0,1,check
	If check < 30 then goto Start 'if acknowledment from DTH is less then 60us then go back to start
	'acknowlegment high pulse 80us . For a 20mhz oscillator pulse width is in 2us increments ie 40us
   
'Get data from temp/humidity module
'Measure high pulse width of each bit and store in pulse. For a 20mhz oscillator pulse width is in 2us increments
   for x = 1 to 40
   pulsin PORTB.0,1,pulse(x)
   next x
       

   ' convert to '0' & '1' 
   for x = 1 to 40
   if pulse(x)>=10 and pulse(x)<=20 then p(x)=0 'if pulse width between 20 and 40uS then read as '0' (22 to 30us is a 0) 20Mhz osc period = measured X 2
   if pulse(x)>=30 and pulse(x)<=45 then p(x)=1 'if pulse width between 60 and 90uS then read as '1' (68 to 75us is a 1)
   next x
  
   
  ' convert bin to dec ==-
   humread=32768*p(1)+16384*p(2)+8192*p(3)+4096*p(4)+2048*p(5)+1024*p(6)+512*p(7)+256*p(8)+128*p(9)+64*p(10)+32*p(11)+16*p(12)+8*p(13)+4*p(14)+2*p(15)+1*p(16)
  tmpread=16384*p(18)+8192*p(19)+4096*p(20)+2048*p(21)+1024*p(22)+512*p(23)+256*p(24)+128*p(25)+64*p(26)+32*p(27)+16*p(28)+8*p(29)+4*p(30)+2*p(31)+1*p(32)
  
  checksum=128*p(33)+64*p(34)+32*p(35)+16*p(36)+8*p(37)+4*p(38)+2*p(39)+1*p(40)

 a = 128*p(1)+64*p(2)+32*p(3)+16*p(4)+8*p(5)+4*p(6)+2*p(7)+1*p(8) 'humidity high byte
 b = 128*p(9)+64*p(10)+32*p(11)+16*p(12)+8*p(13)+4*p(14)+2*p(15)+1*p(16) 'humidity low byte
 c = 128*p(17)+64*p(18)+32*p(19)+16*p(20)+8*p(21)+4*p(22)+2*p(23)+1*p(24)' temperature high byte
 d = 128*p(25)+64*p(26)+32*p(27)+16*p(28)+8*p(29)+4*p(30)+2*p(31)+1*p(32)'temperature low byte
 Y = a + b + c + d 'calculate checksum
 if Y = checksum then goto Display
 goto Display2
 Display2:
  LCDout $FE,$01 'clear display
   LCDout $FE,$80," *",dec humread/10,".",dec humread//10,"%   ",dec tmpread/10,".",dec tmpread//10,"oC" 'print integral part only
  
 pause 2000
 goto Start
   'show real values ==-
   Display:
   LCDout $FE,$01 'clear display
   LCDout $FE,$80," ",dec humread/10,".",dec humread//10,"%   ",dec tmpread/10,".",dec tmpread//10,"oC" 'print integral part only
   
   pause 2000                       'give some time to DHT to stabilize!.... 
   goto Start
   END
